function cap = check_mach_cap(M_cap, CD0tot, base, inputs)
% CHECK_MACH_CAP  Evalúa T vs D en el tope operativo de Mach.
% USO:
%   cap = check_mach_cap();                               % defaults
%   cap = check_mach_cap(M_cap, CD0tot, base, inputs);    % normal

    if nargin < 1 || isempty(M_cap), M_cap = 0.85; end
    if nargin < 4 || isempty(inputs)
        inputs = struct('W',79600,'T_SL_tot',30858,'h_ft',30000,'S',992.8,'AR',7.51,'e',0.612);
    end
    if nargin < 3 || isempty(base)
        atm = isa_std_atmos(inputs.h_ft);
        base = base_quantities(atm, struct('S',inputs.S,'AR',inputs.AR,'e',inputs.e, ...
                        'TSFC_nom',0.60,'TSFC_bleed',0.608,'use_bleed',true));
    end
    if nargin < 2 || isempty(CD0tot)
        CD0tot = build_CD0_total((0.78:0.01:0.86)', 0.0055, 0.0);
    end

    q0S = base.q0S;  k = base.k;  W = inputs.W;
    CD0_cap = interp1(CD0tot.M(:), CD0tot.CD0(:), M_cap,'linear','extrap');

    CL_cap = W/(q0S*M_cap^2);
    CD_cap = CD0_cap + k*(CL_cap^2);
    D_cap  = q0S*(M_cap^2)*CD_cap;

    atm = isa_std_atmos(inputs.h_ft);
    T_avail = inputs.T_SL_tot * atm.sigma;

    cap = struct('CD_cap',CD_cap,'D_cap',D_cap,'T_avail',T_avail);
    if T_avail > D_cap
        cap.governing = sprintf('Gobierna Mach (M<=%.2f)', M_cap);
    else
        cap.governing = 'Gobierna empuje (T_{avail}<=D)';
    end
end



% ============================================================
%   AIRCRAFT PERFORMANCE & DESIGN – PIPELINE ASIGNACIONES 1–4
% ============================================================
%
% 🔹 Propósito
% Este conjunto de funciones automatiza los cálculos de 
% performance (Asignaciones 1–4), permitiendo trabajar tanto
% con CD0 base constante como con la curva ΔCD0(M) digitalizada.
% Los módulos están diseñados para ejecutarse en cadena y 
% generar tablas, gráficas y resúmenes con explicación.
%
% 🔹 Flujo de ejecución principal (pipeline)
%
% run_airperf.m
%   └─> isa_std_atmos     → atm
%   └─> base_quantities   → base
%   └─> build_CD0_total   → CD0tot
%   └─> build_drag_table  → T
%   └─> check_mach_cap    → cap
%   └─> breguet_ER        → breg
%   └─> describe_airperf_outputs(atm, base, CD0tot, T, cap, breg)
%
% 🔹 Descripción de cada módulo
%
% isa_std_atmos(h_ft)
%   ENTRADA: altitud [ft]
%   SALIDA : atm struct con:
%       T_K, T_R, a_fts, rho, sigma
%   → Modelo de atmósfera estándar (ISA).
%
% base_quantities(atm, inputs)
%   ENTRADA: atm, struct inputs con {S, W, AR, e, TSFC, T_SL_tot}
%   SALIDA : base struct con:
%       q0, q0S, k, TSFC corregido
%   → Calcula magnitudes base aerodinámicas.
%
% build_CD0_total(M_grid, CD0_base, dCD0)
%   ENTRADA: malla Mach, CD0_base, curva ΔCD0(M)
%   SALIDA : CD0tot vector
%   → Construye la curva de arrastre parasitario.
%     (dos caminos: CD0_base constante o digitalización ΔCD0).
%
% build_drag_table(M_grid, CD0tot, base, inputs)
%   ENTRADA: Mach grid, CD0tot, base, inputs
%   SALIDA : tabla T con columnas:
%       M, C_D0, C_D, C_L, D_par, D_ind, D_tot
%   → Calcula arrastres parasitario, inducido y total.
%
% check_mach_cap(M_cap, CD0tot, base, inputs)
%   ENTRADA: Mach operativo
%   SALIDA : cap struct con:
%       C_D_cap, D_cap, T_avail
%   → Compara empuje disponible vs arrastre.
%     Determina si gobierna Mach límite o empuje.
%
% breguet_ER(inputs, base, atm)
%   ENTRADA: TSFC, (L/D), Wi/Wf, Mach operativo
%   SALIDA : breg struct con:
%       E (endurance), R (range)
%   → Implementa ecuaciones de Breguet.
%
% describe_airperf_outputs(atm, base, CD0tot, T, cap, breg)
%   ENTRADA: todos los structs anteriores
%   SALIDA : impresión en consola con unidades y explicación
%   → Resume y documenta resultados.
%
% 🔹 Notas de uso
% - Siempre arrancar desde run_airperf.m
% - Cada módulo puede probarse aislado llamando con sus argumentos.
% - Diseñado para Matlab Online con entrada/salida clara y
%   documentada para reportes técnicos en LaTeX.
%
% ============================================================
